/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.architectury.registry.registries.Registries;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import questsadditions.tasks.TasksRegistry;

public class UseTask
extends Task {
    public static final ResourceLocation DEFAULT = new ResourceLocation("minecraft:dirt");
    public ResourceLocation block = DEFAULT;
    public ItemStack item = ItemStack.f_41583_;
    public boolean checkItem;
    public boolean isItemInteraction;
    public long value = 100L;

    public UseTask(Quest quest) {
        super(quest);
    }

    public TaskType getType() {
        return TasksRegistry.USE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("block", this.block.toString());
        nbt.m_128356_("value", this.value);
        nbt.m_128379_("checkItem", this.checkItem);
        nbt.m_128379_("isItemInteraction", this.isItemInteraction);
        NBTUtils.write((CompoundTag)nbt, (String)"item", (ItemStack)this.item);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.block = new ResourceLocation(nbt.m_128461_("block"));
        this.value = nbt.m_128454_("value");
        this.checkItem = nbt.m_128471_("checkItem");
        this.isItemInteraction = nbt.m_128471_("isItemInteraction");
        this.item = NBTUtils.read((CompoundTag)nbt, (String)"item");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.block.toString(), Short.MAX_VALUE);
        buffer.m_130103_(this.value);
        buffer.writeBoolean(this.checkItem);
        buffer.writeBoolean(this.isItemInteraction);
        FTBQuestsNetHandler.writeItemType((FriendlyByteBuf)buffer, (ItemStack)this.item);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.block = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
        this.value = buffer.m_130242_();
        this.checkItem = buffer.readBoolean();
        this.isItemInteraction = buffer.readBoolean();
        this.item = FTBQuestsNetHandler.readItemType((FriendlyByteBuf)buffer);
    }

    public boolean test(ItemStack stack) {
        return ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        ArrayList ids = new ArrayList(Registry.f_122824_.m_6566_());
        TasksRegistry.addEnum(config, "block", this.block, v -> {
            this.block = v;
        }, NameMap.of((Object)DEFAULT, ids).nameKey(v -> "block." + v.m_135827_() + "." + v.m_135815_()).icon(v -> {
            Item item = ((Block)Registry.f_122824_.m_7745_(v)).m_5456_();
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.f_42329_));
        }).create(), DEFAULT);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
        config.addBool("checkItem", this.checkItem, v -> {
            this.checkItem = v;
        }, false);
        config.addBool("isItemInteraction", this.isItemInteraction, v -> {
            this.isItemInteraction = v;
        }, false);
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    @OnlyIn(value=Dist.CLIENT)
    public BaseComponent getAltTitle() {
        return new TranslatableComponent(this.checkItem ? "questsadditions.task.use.item.title" : "questsadditions.task.use.title", new Object[]{this.formatMaxProgress(), new TranslatableComponent("block." + this.block.m_135827_() + "." + this.block.m_135815_()), this.item.m_41720_().m_7626_(this.item)});
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        Item item = ((Block)Registry.f_122824_.m_7745_(this.block)).m_5456_();
        return ItemIcon.getItemIcon((Item)(item != null ? item : Items.f_42329_));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void Use(TeamData teamData, Block block, boolean isItemInteraction, ItemStack itemStack) {
        if (this.isItemInteraction == isItemInteraction && !teamData.isCompleted((QuestObject)this) && this.block.equals((Object)Registries.getId((Object)block, (ResourceKey)Registry.f_122901_)) && (!this.checkItem || this.test(itemStack))) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

